/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CryptoAddressValidator
extends JFrame {
    private JTextField inputField;
    private JTextArea outputArea;
    private JTextArea formattedOutputArea;

    public CryptoAddressValidator() {
        this.setTitle("Crypto Address Validator");
        this.setSize(750, 400);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.inputField = new JTextField();
        JButton jButton = new JButton("Analyze String");
        JButton jButton2 = new JButton("Clear String");
        this.outputArea = new JTextArea();
        this.formattedOutputArea = new JTextArea();
        this.outputArea.setEditable(false);
        this.formattedOutputArea.setEditable(false);
        jButton.addActionListener(this::analyzeString);
        jButton2.addActionListener(this::clearString);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Artifact:"), "West");
        jPanel.add((Component)this.inputField, "Center");
        jPanel.add((Component)jButton2, "East");
        jPanel.add((Component)jButton, "South");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(new JScrollPane(this.outputArea));
        jPanel2.add(new JScrollPane(this.formattedOutputArea));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
    }

    private void clearString(ActionEvent actionEvent) {
        this.inputField.setText("");
    }

    private void analyzeString(ActionEvent actionEvent) {
        String string = this.inputField.getText().replaceAll("\\s+", "");
        if (string.isEmpty()) {
            this.outputArea.setText("Please enter a string to analyze.");
            this.formattedOutputArea.setText("");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (this.isBase62(this.cleanPrefix(string))) {
            if (this.getPrefix(string) != 0) {
                stringBuilder.append("Prefix indicates Base " + this.getPrefix(string) + ".").append("\n\n");
            }
            stringBuilder.append("Potential Base Encodings:\n");
            stringBuilder.append("Base 2: ").append(this.isBase2(this.cleanPrefix(string)) ? "Yes" : "No").append("\n");
            stringBuilder.append("Base 10: ").append(this.isBase10(this.cleanPrefix(string)) ? "Yes" : "No").append("\n");
            stringBuilder.append("Base 16: ").append(this.isBase16(this.cleanPrefix(string)) ? "Yes" : "No").append("\n");
            stringBuilder.append("Base 58: ").append(this.isBase58(this.cleanPrefix(string)) ? "Yes" : "No").append("\n\n");
        } else {
            stringBuilder.append("Not a recognized number: includes characters outside Base 62.\n\n");
        }
        stringBuilder.append("Address Formats:\n");
        if (this.isBitcoinWIF(string)) {
            stringBuilder.append("Bitcoin WIF: Yes\n");
            stringBuilder2.append("Bitcoin WIF Key:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Bitcoin WIF: No\n");
        }
        if (this.isBitcoinCompressedPublicKey(string)) {
            stringBuilder.append("Bitcoin Compressed Public Key: Yes\n");
            stringBuilder2.append("Compressed Public Key:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Bitcoin Compressed Public Key: No\n");
        }
        if (this.isBitcoinUncompressedPublicKey(string)) {
            stringBuilder.append("Bitcoin Uncompressed Public Key: Yes\n");
            stringBuilder2.append("Uncompressed Public Key:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Bitcoin Uncompressed Public Key: No\n");
        }
        if (this.isBitcoinP2PKHAddress(string)) {
            stringBuilder.append("Bitcoin P2PKH Address: Yes\n");
            stringBuilder2.append("P2PKH Address:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Bitcoin P2PKH Address: No\n");
        }
        if (this.isBitcoinBech32P2WPKHAddress(string)) {
            stringBuilder.append("Bitcoin Bech32 P2WPKH Address: Yes\n");
            stringBuilder2.append("Bech32 P2WPKH:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Bitcoin Bech32 P2WPKH Address: No\n");
        }
        if (this.isBitcoinBech32mP2TRAddress(string)) {
            stringBuilder.append("Bitcoin Bech32m P2TR Address: Yes\n");
            stringBuilder2.append("Bech32m P2TR:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Bitcoin Bech32m P2TR Address: No\n");
        }
        if (this.isEthereumAddress(string)) {
            Object object = "";
            stringBuilder.append("Ethereum Address: Yes\n");
            if (CoinFormatHelper.isEthereumAddressHash(string)) {
                object = string;
            } else {
                stringBuilder.append("- Failed capitalization check. Use corrected version to right.\n");
                object = CoinFormatHelper.fixEthereumAddressCapitalization(string);
            }
            if (this.getPrefix((String)object) != 16) {
                object = "0x" + (String)object;
            }
            stringBuilder2.append("Ethereum Address:\n").append((String)object).append("\n\n");
        } else {
            stringBuilder.append("Ethereum Address: No\n");
        }
        if (this.isTronAddress(string)) {
            stringBuilder.append("Tron Address: Yes\n");
            stringBuilder2.append("Tron:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Tron Address: No\n");
        }
        if (this.isRippleAddress(string)) {
            stringBuilder.append("Ripple Address: Yes\n");
            stringBuilder2.append("Ripple:\n").append(string).append("\n\n");
        } else {
            stringBuilder.append("Ripple Address: No\n");
        }
        this.outputArea.setText(stringBuilder.toString());
        this.formattedOutputArea.setText(stringBuilder2.toString());
    }

    private boolean isBase2(String string) {
        return string.matches("[01]+");
    }

    private boolean isBase10(String string) {
        return string.matches("\\d+");
    }

    private boolean isBase16(String string) {
        return string.matches("[0-9a-fA-F]+");
    }

    private boolean isBase58(String string) {
        String string2 = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        return string.matches("[" + string2 + "]+");
    }

    private boolean isBase62(String string) {
        return string.matches("[0-9a-zA-Z]+");
    }

    private String cleanPrefix(String string) {
        if (string.length() < 3) {
            return string;
        }
        if (string.substring(0, 2).equals("0x") || string.substring(0, 2).equals("0b") || string.substring(0, 2).equals("0d")) {
            return string.substring(2);
        }
        return string;
    }

    private int getPrefix(String string) {
        if (string.length() < 3) {
            return 0;
        }
        if (string.substring(0, 2).equals("0x")) {
            return 16;
        }
        if (string.substring(0, 2).equals("0b")) {
            return 2;
        }
        if (string.substring(0, 2).equals("0d")) {
            return 10;
        }
        return 0;
    }

    private boolean isBitcoinWIF(String string) {
        if (!string.matches("^[5KL][1-9A-HJ-NP-Za-km-z]{50,51}$")) {
            return false;
        }
        return CoinFormatHelper.isBitcoinWIFPrivateKeyChecksum(string);
    }

    private boolean isBitcoinCompressedPublicKey(String string) {
        return string.matches("^(02|03)[0-9a-fA-F]{64}$");
    }

    private boolean isBitcoinUncompressedPublicKey(String string) {
        return string.matches("^04[0-9a-fA-F]{128}$");
    }

    private boolean isBitcoinP2PKHAddress(String string) {
        if (!string.matches("^[13][a-km-zA-HJ-NP-Z1-9]{25,34}$")) {
            return false;
        }
        return CoinFormatHelper.isBitcoinP2PKHAddressHash(string);
    }

    private boolean isBitcoinBech32P2WPKHAddress(String string) {
        if (string.length() != 42) {
            return false;
        }
        if (!string.substring(0, 4).matches("bc1q")) {
            return false;
        }
        String string2 = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
        for (int i = 4; i < string.length(); ++i) {
            if (string2.contains(String.valueOf(string.charAt(i)))) continue;
            return false;
        }
        return CoinFormatHelper.isBitcoinP2WPKHAddressHash(string);
    }

    private boolean isBitcoinBech32mP2TRAddress(String string) {
        if (string.length() != 62) {
            return false;
        }
        if (!string.substring(0, 4).matches("bc1p")) {
            return false;
        }
        String string2 = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
        for (int i = 4; i < string.length(); ++i) {
            if (string2.contains(String.valueOf(string.charAt(i)))) continue;
            return false;
        }
        return CoinFormatHelper.isBitcoinP2TRAddressHash(string);
    }

    private boolean isEthereumAddress(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 3) {
            return false;
        }
        if (string.substring(0, 2).equals("0x")) {
            string = string.substring(2);
        }
        return string.length() == 40 && string.matches("[0-9a-fA-F]+");
    }

    private boolean isTronAddress(String string) {
        if (string == null || string.charAt(0) != 'T') {
            return false;
        }
        if (string.length() != 34) {
            return false;
        }
        if (!this.isBase58(string)) {
            return false;
        }
        return CoinFormatHelper.isTronAddressHash(string);
    }

    private boolean isRippleAddress(String string) {
        if (string == null || !this.isBase58(string)) {
            return false;
        }
        if (string.length() < 25 || string.length() > 35) {
            return false;
        }
        if (string.charAt(0) != 'r') {
            return false;
        }
        return CoinFormatHelper.isRippleAddressHash(string);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> new CryptoAddressValidator().setVisible(true));
    }
}

